package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.slotscartes;

import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement : Initialisation du code PIN
 *
 */
public class InitPIN{
	
	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(InitPIN.class);
	
	/**
	 * Renvoie le rsultat de l'opration
	 * @param librairie Librairie PKCS#11  utiliser
	 * @param idSession Identifiant de la session
	 * @param pin Le code porteur (PIN)
	 * @return Rsultat de l'opration
	 * @throws ExceptionTraitement 
	 */
	public static Resultat traitementP11(PKCS11 librairie, long idSession, char[] pin) throws ExceptionTraitement {

		try {
		
			if(librairie != null) {
		
			Resultat resultat = new Resultat("Initialisation du code porteur de la carte (C_InitPIN)");
			
			try {
				
				if(pin != null)
					// Traitement  tester
					librairie.C_InitPIN(idSession, pin);
				else {
					
					// Si le PIN est nul on lve l'exception
					log.error("Le code PIN est nul");
					throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INIT_PIN, "Le code PIN est nul");
					
				}
	
				
			} catch (PKCS11Exception e) {
				
				log.info("Operation echouee : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
				resultat.setCodeRetour(e.getErrorCode());
				
			}
			
			return resultat;
			
			} else {
	
				// Si la librairie est nulle il est impossible de raliser l'opration
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INIT_PIN, "La librairie est nulle");
				
			}
			
		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue on la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SLOTSCARTES_INIT_PIN, "Une erreur inattendue est survenue");
			
		}
	}

}
